CREATE TRIGGER E_DDL_BASE_CREATE_TABLE_CONFORME
ON DATABASE
FOR CREATE_TABLE
AS
BEGIN --> TRIGGER CODE

-- Rcupration du nom de la table
DECLARE @TABLE_NAME sysname, @TABLE_SCHEMA sysname;
SELECT @TABLE_NAME = EVENTDATA().value('(/EVENT_INSTANCE/ObjectName)[1]', 'sysname'),
       @TABLE_SCHEMA = EVENTDATA().value('(/EVENT_INSTANCE/ObjectSchema)[1]', 'sysname');

BEGIN TRY --> EXCEPTION TEST

-- Un nom de table doit commencer par T_
IF @TABLE_NAME NOT LIKE 'T?_%' ESCAPE '?'
   THROW 66666, 'Le nom d''une table doit commencer par "T_"', 16;

-- Le trigramme doit tre prcd dun espace soulign
IF RIGHT(@TABLE_NAME, 4) NOT LIKE '?_%' ESCAPE '?'
   THROW 66666, 'Le trigramme doit tre prcd d''un espace soulign', 16;

-- Le trigramme ne doit pas comporter despace soulign
IF RIGHT(@TABLE_NAME, 3) LIKE '%?_%' ESCAPE '?'
   THROW 66666, 'Le trigramme ne doit pas comporter d''espace soulign', 16;

-- Le nom de la table doit tre en majuscules
IF @TABLE_NAME <> UPPER(@TABLE_NAME) COLLATE French_BIN2
   THROW 66666, 'Le nom d''une table doit tre en majuscules', 16;

-- Le nom de la table ne doit comporter que les caractres [A..Z] U [0..1] U [ _ ]
IF dbo.F_VALIDATION_NOM_SQL(@TABLE_NAME) = 0
   THROW 66666, 'Le nom ne doit pas comporter de caractres illicites', 16;

-- Le trigramme doit tre unique
IF dbo.F_TRIGRAMME_UNIQUE(@TABLE_NAME, 'TABLE') = 0
   THROW 66666, 'Le trigramme doit tre unique dans l''ensemble de tables', 16;

-- Les colonnes non FK doivent commencer par le trigramme de la table
IF EXISTS
(
SELECT *
FROM   INFORMATION_SCHEMA.COLUMNS AS C
       INNER JOIN INFORMATION_SCHEMA.TABLES AS T
             ON C.TABLE_SCHEMA = T.TABLE_SCHEMA
                AND C.TABLE_NAME = T.TABLE_NAME
WHERE  C.TABLE_SCHEMA = @TABLE_SCHEMA
  AND  C.TABLE_NAME = @TABLE_NAME
  AND  T.TABLE_TYPE = 'BASE TABLE'
  AND  LEFT(C.COLUMN_NAME, 4) <> RIGHT(C.TABLE_NAME, 3) +'_'
  AND  C.COLUMN_NAME NOT IN(SELECT KCU.COLUMN_NAME
                            FROM   INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS TC
                                   INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KCU
                                         ON KCU.CONSTRAINT_SCHEMA = TC.CONSTRAINT_SCHEMA
                                            AND KCU.CONSTRAINT_NAME = TC.CONSTRAINT_NAME
                                   INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS AS R
                                         ON TC.CONSTRAINT_SCHEMA = R.CONSTRAINT_SCHEMA
                                            AND TC.CONSTRAINT_NAME = R.CONSTRAINT_NAME
                            WHERE  TC.TABLE_SCHEMA = C.TABLE_SCHEMA
                              AND  TC.TABLE_NAME = C.TABLE_NAME)
)
   THROW 66666,'Une colonne non FK doit dbuter par le trigramme de table', 16;

-- Une colonne FK doit commencer par sa colonne de rfrence
IF EXISTS
(
SELECT *
FROM   INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS TC
       INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KCU
             ON KCU.CONSTRAINT_SCHEMA = TC.CONSTRAINT_SCHEMA
                AND KCU.CONSTRAINT_NAME = TC.CONSTRAINT_NAME
       INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS AS RC
             ON TC.CONSTRAINT_SCHEMA = RC.CONSTRAINT_SCHEMA
                AND TC.CONSTRAINT_NAME = RC.CONSTRAINT_NAME
       INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KCR
             ON RC.UNIQUE_CONSTRAINT_SCHEMA = KCR.CONSTRAINT_SCHEMA
                AND RC.UNIQUE_CONSTRAINT_NAME = KCR.CONSTRAINT_NAME
WHERE  CONSTRAINT_TYPE = 'FOREIGN KEY'
  AND  KCU.COLUMN_NAME NOT LIKE KCR.COLUMN_NAME +'%'
  AND  TC.TABLE_SCHEMA = @TABLE_SCHEMA
  AND  TC.TABLE_NAME = @TABLE_NAME
)
   THROW 66666,'Une colonne FK doit dbuter par sa colonne de rfrence', 16;

END TRY --> EXCEPTION TEST

BEGIN CATCH --> EXCEPTION CATCH
   IF XACT_STATE() <> 0
      ROLLBACK;
   THROW;
END CATCH --> EXCEPTION CATCH

END --> TRIGGER CODE
GO

--> NOTA : la requte dans le livre est errone. Il manque deux lignes juste aprs la dernire ligne de la page 903. la prsente requte corrige cela.